---
title: Origin configuration parameters · Cloudflare One docs
description: Origin configuration parameters determine how cloudflared proxies
  traffic to your origin server. If you are using remotely-managed tunnels
  (default), configure these settings using the dashboard or API. If you are
  using locally-managed tunnels, add these parameters to your configuration
  file.
lastUpdated: 2025-10-24T20:47:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cloudflared-parameters/origin-parameters/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cloudflared-parameters/origin-parameters/index.md
---

Origin configuration parameters determine how `cloudflared` proxies traffic to your origin server. If you are using remotely-managed tunnels (default), configure these settings [using the dashboard or API](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cloudflared-parameters/#update-origin-configuration). If you are using [locally-managed tunnels](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/do-more-with-tunnels/local-management/), add these parameters to your [configuration file](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/do-more-with-tunnels/local-management/configuration-file/).

## TLS settings

### originServerName

| Default | UI name |
| - | - |
| `""` | Origin Server Name |

Hostname that `cloudflared` should expect from your origin server certificate. If null, the expected hostname is the service URL, for example `localhost` if the service is `https://localhost:443`.

### caPool

| Default | UI name |
| - | - |
| `""` | Certificate Authority Pool |

Local file path to the certificate authority (CA) for your origin server certificate (for example, `/root/certs/ca.pem`). The path should point to a certificate store file or a bundle file in `.pem` or `.crt` format that contains one or more trusted root CA certificates. You should only configure this setting if your certificate is not signed by Cloudflare.

### noTLSVerify

| Default | UI name |
| - | - |
| `false` | No TLS Verify |

When `false`, TLS verification is performed on the certificate presented by your origin.

When `true`, TLS verification is disabled. This will allow any certificate from the origin to be accepted.

### tlsTimeout

| Default | UI name |
| - | - |
| `10s` | TLS Timeout |

Timeout for completing a TLS handshake to your origin server, if you have chosen to connect Tunnel to an HTTPS server.

### http2Origin

| Default | UI name |
| - | - |
| `false` | HTTP2 connection |

When `false`, `cloudflared` will connect to your origin with HTTP/1.1.

When `true`, `cloudflared` will attempt to connect to your origin server using HTTP/2.0 instead of HTTP/1.1. HTTP/2.0 is a faster protocol for high traffic origins but requires you to deploy an SSL certificate on the origin. We recommend using this setting in conjunction with [noTLSVerify](#notlsverify) so that you can use a self-signed certificate.

## HTTP settings

### httpHostHeader

| Default | UI name |
| - | - |
| `""` | HTTP Host Header |

Sets the HTTP `Host` header on requests sent to the local service.

### disableChunkedEncoding

| Default | UI name |
| - | - |
| `false` | Disable Chunked Encoding |

When `false`, `cloudflared` performs chunked transfer encoding when transferring data over HTTP/1.1.

When `true`, chunked transfer encoding is disabled. This is useful if you are running a Web Server Gateway Interface (WSGI) server.

## Connection settings

### connectTimeout

| Default | UI name |
| - | - |
| `30s` | Connect Timeout |

Timeout for establishing a new TCP connection to your origin server. This excludes the time taken to establish TLS, which is controlled by tlsTimeout.

### noHappyEyeballs

| Default | UI name |
| - | - |
| `false` | No Happy Eyeballs |

When `false`, `cloudflared` uses the Happy Eyeballs algorithm for IPv4/IPv6 fallback if your local network has misconfigured one of the protocols.

When `true`, Happy Eyeballs is disabled.

### proxyType

| Default | UI name |
| - | - |
| `""` | Proxy Type |

`cloudflared` starts a proxy server to translate HTTP traffic into TCP when proxying, for example, SSH or RDP. This configures what type of proxy will be started. Valid options are:

* `""` for the regular proxy
* `"socks"` for a SOCKS5 proxy. Refer to the [tutorial on connecting through Cloudflare Access using kubectl](https://developers.cloudflare.com/cloudflare-one/tutorials/kubectl/) for more information.

### proxyAddress

Note

For locally-managed tunnels only.

| Default | UI name |
| - | - |
| `127.0.0.1` | -- |

`cloudflared` starts a proxy server to translate HTTP traffic into TCP when proxying, for example, SSH or RDP. This configures the listen address for that proxy.

### proxyPort

Note

For locally-managed tunnels only.

| Default | UI name |
| - | - |
| `0` | -- |

`cloudflared` starts a proxy server to translate HTTP traffic into TCP when proxying, for example, SSH or RDP. This configures the listen port for that proxy. If set to zero, an unused port will randomly be chosen.

### keepAliveTimeout

| Default | UI name |
| - | - |
| `1m30s` | Idle Connection Expiration Time |

Timeout after which an idle keepalive connection can be discarded.

### keepAliveConnections

| Default | UI name |
| - | - |
| `100` | Keep Alive Connections |

Default: `100`

Maximum number of idle keepalive connections between Cloudflare and your origin. This does not restrict the total number of concurrent connections.

### tcpKeepAlive

| Default | UI name |
| - | - |
| `30s` | TCP Keep Alive Interval |

Default: `30s`

The timeout after which a TCP keepalive packet is sent on a connection between Cloudflare and the origin server.

## Access settings

### access

| Default | UI name |
| - | - |
| `""` | Protect with Access |

Requires `cloudflared` to validate the [Cloudflare Access JWT](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/authorization-cookie/validating-json/) prior to proxying traffic to your origin. You can enforce this check on public hostname services that are protected by an Access application. For all L7 requests to these hostnames, Access will send the JWT to `cloudflared` as a `Cf-Access-Jwt-Assertion` request header.

To enable this security control in a [configuration file](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/do-more-with-tunnels/local-management/configuration-file/#origin-configuration), [get the AUD tag](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/authorization-cookie/validating-json/#get-your-aud-tag) for your Access application and add the following rule to `originRequest`:

```yml
access:
  required: true
  teamName: <your-team-name>
  audTag:
    - <Access-application-audience-tag>
    - <Optional-additional-tags>
```
