---
title: Transfer your domain to Cloudflare · Cloudflare Registrar docs
description: This page contains generic instructions on how to transfer your
  domain to Cloudflare.
lastUpdated: 2025-10-09T15:47:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/registrar/get-started/transfer-domain-to-cloudflare/
  md: https://developers.cloudflare.com/registrar/get-started/transfer-domain-to-cloudflare/index.md
---

Transferring your domain to Cloudflare tells your registry that a different registrar can now set those authoritative records for you. The relationship is based on trust. Registries only trust one registrar at any given time to make changes on your behalf.

Transferring a domain to a new registrar informs the registry that they should instead trust that new registrar to modify information. The process requires some action steps at your new and previous registrar. Each registrar handles transfers a bit differently, but in general, they follow a pattern based on rules set by ICANN, the organization responsible for regulating domain registration.

Most domain transfers add one additional year to your current registration term. After the transfer, your domain registration will be set to auto-renew by default.

This page contains generic instructions on how to transfer your domain to Cloudflare from most registrars.

***

## Requirements

All domains using Cloudflare Registrar must use Cloudflare for authoritative DNS on a [full setup](https://developers.cloudflare.com/dns/zone-setups/full-setup/)[1](#user-content-fn-1). This means [onboarding your domain](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/) by [updating your nameservers](https://developers.cloudflare.com/dns/nameservers/update-nameservers/) to your assigned Cloudflare nameservers. You cannot change to another DNS provider's nameservers while using Cloudflare Registrar.

## Footnotes

1. Meaning Cloudflare is your primary, authoritative DNS provider. [↩](#user-content-fnref-1)

***

## Before transferring a domain to Cloudflare

* Create [a Cloudflare account](https://developers.cloudflare.com/fundamentals/account/create-account/).
* [Add the domain](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/) you are transferring to your Cloudflare account.
* [Review your DNS records](https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/#review-dns-records) in the Cloudflare dashboard.
* If needed, plan for [DNSSEC disablement](#disable-dnssec).
* [Change your DNS nameservers](https://developers.cloudflare.com/dns/zone-setups/full-setup/) to Cloudflare.
* If initiating multiple transfers, notify your financial institution to prevent them from flagging these charges as fraudulent.
* Renew your domain if it is within 15 days of expiration.
* Do not make any changes to the Registrant contact information. Updating the Registrant contact may result in your current registrar locking the domain for 60 days.
* Make sure your account has a valid credit card on file.
* If you are transferring a `.us` domain, refer to the [Additional requirements for .US domains](https://developers.cloudflare.com/registrar/top-level-domains/us-domains/) before proceeding.

### Disable DNSSEC

If you are onboarding an existing domain to Cloudflare, make sure DNSSEC **is disabled** at your registrar. Otherwise, your domain will experience connectivity errors when you change your nameservers.

1. Take note of the TTL value for the DS record at your current registrar.

2. Remove DS records at your current registrar.

   Provider-specific instructions

   This is not an exhaustive list of how to update DS records in other providers, but the following links may be helpful:

   * [DNSimple](https://support.dnsimple.com/articles/cloudflare-ds-record/)
   * [Domaindiscount24](https://support.domaindiscount24.com/hc/articles/4409759478161)
   * [DreamHost](https://help.dreamhost.com/hc/en-us/articles/219539467)
   * [Dynadot](https://www.dynadot.com/community/help/question/set-DNSSEC)
   * [Enom](https://help.enom.com/hc/en-us/articles/115001028212)
   * [Gandi](https://wiki.gandi.net/en/domains/dnssec)
   * [GoDaddy](https://ph.godaddy.com/help/add-a-ds-record-23865)
   * [Hostinger](https://support.hostinger.com/articles/3667267)
   * [Hover](https://help.hover.com/hc/en-us/articles/217281647)
   * [InMotion Hosting](https://www.inmotionhosting.com/support/edu/cpanel/enable-dnssec-cloudflare/)
   * [INWX](https://kb.inwx.com/en-us/3-nameserver/131)
   * [Joker.com](https://joker.com/faq/books/jokercom-faq-en/page/dnssec)
   * [Name.com](https://www.name.com/support/articles/205439058-managing-dnssec)
   * [Namecheap](https://www.namecheap.com/support/knowledgebase/article.aspx/9722/2232/managing-dnssec-for-domains-pointed-to-custom-dns)
   * [NameISP](https://support.nameisp.com/answers/dns)
   * [Namesilo](https://www.namesilo.com/Support/DS-Records-%28DNSSEC%29)
   * [OVH](https://help.ovhcloud.com/csm/en-dns-secure-domain-dnssec?id=kb_article_view\&sysparm_article=KB0051637)
   * [Squarespace](https://support.squarespace.com/hc/articles/4404183898125-Nameservers-and-DNSSEC-for-Squarespace-managed-domains#toc-dnssec)
   * [Registro.br](https://registro.br/tecnologia/dnssec.html?secao=tutoriais-dns)
   * [Porkbun](https://kb.porkbun.com/article/93-how-to-install-dnssec) (do not fill out **keyData**)
   * [TransIP](https://www.transip.eu/knowledgebase/entry/150-secure-domains-custom-nameservers-dnssec/)

3. Wait at least the time corresponding to the DS record TTL. It is usually 24 hours, but refer to the value you got in step 1.

4. Follow the steps to [transfer your domain](https://developers.cloudflare.com/registrar/get-started/transfer-domain-to-cloudflare/#set-up-a-domain-transfer) to Cloudflare Registrar.

5. [Enable DNSSEC](https://developers.cloudflare.com/dns/dnssec/#1-activate-dnssec-in-cloudflare) at Cloudflare. This will automatically add your DS to the zone parent via Cloudflare Registrar.

Why you have to disable DNSSEC

When your domain has [DNSSEC enabled](https://www.cloudflare.com/learning/dns/dns-security/#what-is-dnssec), your DNS provider digitally signs all your DNS records. This action prevents anyone else from issuing false DNS records on your behalf and redirecting traffic intended for your domain.

However, having a single set of signed records also prevents Cloudflare from issuing new DNS records on your behalf (which is part of using Cloudflare for your authoritative nameservers). So if you change your nameservers without disabling DNSSEC, DNSSEC will prevent Cloudflare's DNS records from resolving properly.

***

## Restrictions

To transfer your domain, it must meet the following requirements:

* ICANN rules prohibit a domain from being transferred if it has been registered or previously transferred within the last 60 days or if the WHOIS Registrant contact information was modified in the last 60 days (even if redacted).

* Your account at your current registrar must be active. If your domain has expired, you may be able to transfer the domain. If the domain is in the `RedemptionPeriod` you will likely need to restore the domain first before the transfer can proceed.

  Warning

  The transfer of an expired domain may result in an additional year NOT being added during the transfer.

* Your domain cannot be an internationalized domain name (IDNs) as Cloudflare does not currently support them. These domains are also known as unicode.

* Domains that have a status of `serverHold`, `serverTransferProhibited`, `pendingDelete`, `pendingTransfer`, or `RedemptionPeriod` may not be transferred.

* Domains that have a status of `clientTransferProhibited` (Transfer Lock) will not show as available for transfer. You will have to unlock the domain at your current registrar before being able to proceed.

If your domain is listed as available for transfer in the Cloudflare dashboard, these restrictions have already been checked.

***

## Set up a domain transfer

To begin, complete the following steps in your current registrar to transfer your domain to Cloudflare. Below, you will find links for detailed transfer instructions from some of the most popular registrars:

* [Enom](https://support.enom.com/support/solutions/articles/201000065324-preparing-your-domain-for-transfer)
* [GoDaddy](https://www.godaddy.com/help/transfer-my-domain-away-from-godaddy-3560)
* [Ionos by 1&1](https://www.ionos.com/help/domains/domain-transfers/#acc4514)
* [Namecheap](https://www.namecheap.com/support/knowledgebase/article.aspx/258/84/what-should-i-do-to-transfer-a-domain-from-namecheap/)
* [Network Solutions](https://www.networksolutions.com/help/article/transfer-out-of-network-solutions)
* [Squarespace](https://support.squarespace.com/hc/articles/205812338-Transferring-a-domain-away-from-Squarespace)

### 1. Log in to your registrar account

Log in to the registrar account where the domain is currently registered.

### 2. Unlock the domain

Registrars include a lightweight safeguard to prevent unauthorized users from starting domain transfers. This is known as registrar lock, but you might also see it referred to as domain lock. In WHOIS, it may appear as `clientTransferProhibited`. When enabled, the lock prevents any other registrar from attempting to initiate a transfer.

Only the registrant can enable or disable this lock, typically through the administration interface of the registrar. To proceed with a transfer, remove this lock if it is enabled.

### 3. Remove WHOIS privacy

In most cases, domains may be transferred even if WHOIS privacy services have been enabled. However, some registrars may prohibit the transfer if the WHOIS privacy service has been enabled.

### 4. Request an authorization code

Your new registrar needs to confirm with your old registrar that the transfer flow is authorized. To do that, your old registrar will provide an authorization code to you.

Note

This code is often referred to as an authorization code, auth code, authinfo code, or transfer code. You will need to input that code to complete your transfer to Cloudflare. Cloudflare will use it to confirm the transfer is authentic.

### 5. Initiate your transfer to Cloudflare

From your Cloudflare Account Home, go to the **Transfer Domains** page.

[Go to **Transfer domains**](https://dash.cloudflare.com/?to=/:account/registrar/transfer)

Cloudflare Registrar will display the zones available for transfer.

You will be presented with the price for each transfer. When you transfer a domain, you are required by ICANN to pay to extend its registration by one year from the expiration date. You can remove domains from your transfer by selecting **x**.

If you do not have a payment method on file, add one at this step before proceeding.

You will not be billed at this step. Cloudflare will only bill your card when you input the auth code and confirm the contact information at the conclusion of your transfer request.

In some cases, premium (non-standard priced) domains may not be detected immediately. Pricing will be confirmed with the registry before submission, and you will have the opportunity to review and approve any price adjustments.

In most cases, transferring a domain adds one additional year to its registration term. However, the following exceptions apply:

* Transferring a `.uk` domain does not extend its registration by an additional year.
* If the transfer is completed within 45 days of the domain's expiration, the extra year may not be added. This is determined by the domain's Registry.
* If the domain already has more than nine years remaining, a full year may not be added. This is also subject to Registry policy.

Note

Sites can be unavailable to transfer for a few reasons, including:

* You did not [add your domain](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/) to your Cloudflare.
* The site was registered in the last 60 days.
* Cloudflare does not yet support the TLD.
* The domain has a status that does not allow for a transfer.
* You failed to follow the steps highlighted above in [creating an account with your domain](https://developers.cloudflare.com/fundamentals/account/create-account/) and [changing your DNS nameservers to Cloudflare](https://developers.cloudflare.com/dns/zone-setups/full-setup/).

Note

If you have an [unverified account email address](https://developers.cloudflare.com/fundamentals/user-profiles/verify-email-address/), you will not be able to transfer or register domains. Verify your account email address before proceeding.

### 6. Input your authorization code

In the next page, input the authorization code for each domain you are transferring. You also need to unlock each domain so that Cloudflare can process your request. For more information, refer to the instructions provided by your [current registrar on how to transfer your domain](https://developers.cloudflare.com/registrar/get-started/transfer-domain-to-cloudflare/#set-up-a-domain-transfer).

### 7. Confirm or input your contact information

In the final stage of the transfer process, input the contact information for your registration. Cloudflare Registrar redacts this information by default but is required to collect the authentic contact information for this registration. It is important that you provide accurate WHOIS contact information. You may be required to verify the contact information. Failure to provide accurate information and/or failure to verify the information may result in suspension or deletion of your domain.

You can always [modify the contact information](https://developers.cloudflare.com/registrar/account-options/domain-contact-updates/) later, if needed.

After entering the contact information, agree to the domain registration terms of service by selecting **Confirm transfer**.

### 8. Approve the transfer

Once you have requested your transfer, Cloudflare will begin processing it, and send a Form of Authorization (FOA) email to the registrant, if the information is available in the public WHOIS database. The FOA is what authorizes the domain transfer.

After this step, your previous registrar will also email you to confirm your request to transfer. Most registrars will include a link to confirm the transfer request. If you select that link, you can accelerate the transfer operation. If you do not act on the email, the registrar can wait up to five days to process the transfer to Cloudflare. You may also be able to approve the transfer from within your current registrar dashboard.

Note

Registrants transferring a `.us` domain will always receive a FOA email.

## Bulk domain transfers

The process for transferring domains in bulk to Cloudflare is the same process as transferring a single domain. Even if you transfer multiple domains in bulk, you will be charged for each domain as bulk billing is not yet available.

## Transfer statuses

You can check the status of your transfer in **Account Home** > **Overview** > **Domain Registration** for your domain. Below, you can find a list of the possible transfer statuses.

* **Transfer in progress**: Your request has been submitted by Cloudflare to your previous registrar. Cloudflare is now waiting on them to confirm they have received the request. If this status persists for more than a day (24 hours), ensure that the domain has been unlocked at your current registrar and any WHOIS privacy services have been removed.

* **Pending approval**: Your current registrar has received the transfer request. They can now wait up to five days to release the domain. If you want to move faster, you can manually approve the transfer for immediate release in the dashboard of most registrars.

* **Transfer rejected**: your transfer has been rejected. This can occur if you canceled the request at your current registrar instead of approving it. If you still wish to transfer, you can select **Retry** and initiate a new transfer request.

## Next steps

As mentioned in [Review DNS records in Cloudflare](https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/#review-dns-records), when moving your domain to Cloudflare Registrar, you might need to configure your DNS records to correctly point traffic to your web host. Cloudflare automatically scans for common records and adds them to your account's DNS page, but the scan is not guaranteed to find all existing DNS records.

Refer to your web host's documentation to learn what type of records you need to configure and where they should point, to avoid downtime.

Example

For example, Netlify asks customers that host websites with them to add a `CNAME` record pointing `<YOUR-DOMAIN>` to `apex-loadbalancer.netlify.com`, and another `CNAME` record pointing `www` to `<YOUR-DOMAIN>.netlify.app`, depending on which one is the primary domain.

![An example of DNS management in Cloudflare's DNS dashboard](https://developers.cloudflare.com/_astro/dns-management.0LI9Ggoq_2X8BL.webp)

You may also want to [enable DNSSEC](https://developers.cloudflare.com/dns/dnssec/#1-activate-dnssec-in-cloudflare).
