---
title: Rate limiting rulesets · Cloudflare Web Application Firewall (WAF) docs
description: A rate limiting rule defines a rate limit for requests matching an
  expression, and the action to perform when that rate limit is reached. At the
  account level, rate limiting rules are always grouped into rate limiting
  rulesets, which you then deploy.
lastUpdated: 2025-09-22T16:52:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/account/rate-limiting-rulesets/
  md: https://developers.cloudflare.com/waf/account/rate-limiting-rulesets/index.md
---

A rate limiting rule defines a rate limit for requests matching an expression, and the action to perform when that rate limit is reached. At the account level, rate limiting rules are always grouped into rate limiting rulesets, which you then deploy.

Note

This feature requires an Enterprise plan with a paid add-on.

To apply a rate limiting ruleset at the account level, create a custom rate limiting ruleset with one or more [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/), and then deploy it to one or more zones on an Enterprise plan.

For more information on how Cloudflare calculates request rates, refer to [Request rate calculation](https://developers.cloudflare.com/waf/rate-limiting-rules/request-rate/).

## Next steps

For instructions on creating and deploying a rate limiting ruleset, refer to the following pages:

* [Create a rate limiting ruleset in the dashboard](https://developers.cloudflare.com/waf/account/rate-limiting-rulesets/create-dashboard/)
* [Create a rate limiting ruleset using the API](https://developers.cloudflare.com/waf/account/rate-limiting-rulesets/create-api/)

For Terraform examples, refer to [Rate limiting rules configuration using Terraform](https://developers.cloudflare.com/terraform/additional-configurations/rate-limiting-rules/).
