---
title: Configuration settings · Cloudflare Waiting Room docs
description: You can customize a variety of options for your waiting rooms.
lastUpdated: 2025-08-18T14:27:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waiting-room/reference/configuration-settings/
  md: https://developers.cloudflare.com/waiting-room/reference/configuration-settings/index.md
---

You can customize a variety of options for your waiting rooms.

[Dashboard settings ](#dashboard-settings)[Additional details](#additional-details)

## Dashboard settings

| **Settings** | **Notes** | | | | |
| - | - | - | - | - | - |
| **Dashboard Setting** | **API parameter** | **Required?** | **Description** | **Best practices** | |
| Name | `name` | Yes | Unique waiting room name. | | |
| Hostname | `host` | Yes | Hostname for which the waiting room will be applied (no wildcards). | Do not include `http://` or `https://`. | |
| Path | `path` | No | Case-sensitive path of the waiting room. The waiting room will be enabled for all subpaths. Wildcards and query parameters are not supported. | If your server does not allow letter casing, use numbers in your `path`. | |
| Additional Hostnames and Paths | `additional_routes` | No | Add additional hostnames and/or paths to your waiting room coverage. | Additional hostnames must be within the same zone. Hostname and path combinations must be unique per waiting room. | |
| Custom Cookie Suffix | `cookie_suffix` | Required when using `additional_routes`. | Customize the suffix of your waiting room cookie. Suffix will be added to `_cfwaitingroom`. | Ensure your cookie name is compliant. Do not change this often. | |
| Total active users | `total_active_users` | Yes | The maximum number of active sessions allowed in `host/path` at a given time (must be greater than 200). | Set to 75% of origin traffic capacity and adjust as needed. Adjustments may affect estimated wait time shown to end users. | |
| New users per minute | `new_users_per_minute` | Yes | A [threshold](#new-users-per-minute) of users per minute that can be allowed into `host/path`, greater than 200 and less than or equal to **total active users**. | Set to 100% of peak traffic to ensure users are only queued when necessary | |
| Session duration | `session_duration` | No | The amount of time in minutes (between 1 and 30) that a user who left `host/path` can come [directly back](#session-duration) without having to go into the waiting room. Defaults to 5 minutes. | | |
| Session Revocation | `` | No | Revoke a user's session when they perform a specific action by sending a command to the waiting room using an HTTP header on the response from your origin. | Enable this setting in the dashboard and add the `Cf-Waiting-Room-Command: revoke` HTTP header to the response from your origin. | |
| Description | `description` | No | Description of the waiting room. | | |
| Disable session renewal | `disable_session_renewal` | No | Only available to Enterprise customers with purchase. If true, users only have `session duration` minutes to browse your site. If false, a user's session cookie is renewed on every request. | | |
| JSON response | `json_response_enabled` | No, defaults to false. | Send JSON body when receiving an `Accept: application/json` header, commonly used with native mobile applications. | Set to `true` when using a waiting room for non-browser traffic. Follow [this documentation](https://developers.cloudflare.com/waiting-room/how-to/json-response/) for additional steps. | |
| Queueing status code | `queueing_status_code` | No, defaults `200` (OK). | HTTP status code to be returned while a user is queuing. | | |
| Turnstile Widget Mode | `turnstile_mode` | Yes, defaults `invisible`. | The type of Turnstile widget to use - refer to the [Turnstile documentation](https://developers.cloudflare.com/turnstile/concepts/widget/#widget-modes) for details. Valid values are `off`, `invisible`, `visible_non_interactive`, and `visible_managed`. Setting this to `off` will completely disable the Turnstile integration. | Setting this to `invisible` makes sense for most rooms, unless you would like end users to be aware the challenge is running. | |
| Turnstile Fail Action | `turnstile_action` | Yes, defaults to `log`. | The action to take when an end user fails a Turnstile challenge. Valid values are `log` and `infinite_queue`. | Setting this to `log` makes sense for most rooms, unless you wish to aggressively block bots using an infinite queue. | |

## Additional details

### New users per minute

When you configure `new users per minute`, this value **is not** the number of users added per minute.

Instead, it is the threshold of users allowed per minute (less than or equal to the number of `total active users`). You should set this value at 100% of your expected peak traffic to ensure users are only queued when necessary.

### Session duration

Session duration improves user experience in two ways.

First, it prevents visitors from having to pass through a waiting room twice for the same transaction. For example, a visitor might want to make a purchase at `example.com`. There's a lot of traffic at `example.com`, so they queue in the waiting room before entering the online store. After a period of time, they leave the waiting room and enter the online store. They make a purchase and leave the online store.

However, they forgot to add a note to the order or request a receipt. As long as their [session cookie](https://developers.cloudflare.com/waiting-room/reference/waiting-room-cookie/) is still valid (for the length of time specified by the `session duration`), they can re-enter your application without having to re-queue in the waiting room.

Second, session duration lets your waiting room create a dynamic outflow from your application (in addition to dynamic inflow). A user's session cookie expires after a period of inactivity, meaning that new spots can open up as soon as space becomes available and estimated wait times are lower and more accurate.
