---
title: Return small HTML page · Cloudflare Workers docs
description: Deliver an HTML page from an HTML string directly inside the Worker script.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
tags: JavaScript,TypeScript,Python,Rust
source_url:
  html: https://developers.cloudflare.com/workers/examples/return-html/
  md: https://developers.cloudflare.com/workers/examples/return-html/index.md
---

If you want to get started quickly, click on the button below.

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/docs-examples/tree/main/workers/return-html)

This creates a repository in your GitHub account and deploys the application to Cloudflare Workers.

* JavaScript

  ```js
  export default {
    async fetch(request) {
      const html = `<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>`;


      return new Response(html, {
        headers: {
          "content-type": "text/html;charset=UTF-8",
        },
      });
    },
  };
  ```

  [Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAwAmYQE4ALAGYxAdgAcAVgBs8gFwsWbYBzhcafASPHS5S1QFgAUAGF0VCAFMH2ACJQAzjHQeo0e2ok2ngExCRUcMCODABEUDSOAB4AdABWHjGkqFBgzpHRcQkp6THWdg7OENgAKnQwjoFwMDBgfARQ9sipcABucB68CLAQANTA6LjgjtbWSd5IJLiOqHDgECQA3lYkJP10VLxBjhC8ABYAFAiOAI4gjh4QAJSb2zskvPYPJKcQwGAkDBIAAMADwAQlcAHkbNUAJoABQAot9fmAAHyvHYgii4OgYt5vEGnACMaIAEo4wGB0CQAOqYMC4EHIEn4gkkEEwNHVU6eEjARAAaxAMBIAHd+iQAObORwIAiOXDkOi7Eg2akgXCoMCIRx0zCCuXJZlczEc5A4vFAohWM1XCAgBBUcKOMUkABK928VA8jnOPz+ABoXuzvo44EsEB5AltQzsYh8Ki4IHVHDFAjEnIkUAGwEQzohfRAGABVaoAMWw8higbNOwAvrWCfXHjaG7X60RrJpmNpdPoePwhKJJDIFCp5GV7E4XO4vD4-B0qIFgrpSBEorEooRdJkgjk8puYmRqWRSrZp5UaqnGs1Wrx2p10vYZlYNjEBfEAPrjSa5dOFEsxQZPW3Y9n2oQDoYw4mGO5jyMw1hAA)

* TypeScript

  ```ts
  export default {
    async fetch(request): Promise<Response> {
      const html = `<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>`;


      return new Response(html, {
        headers: {
          "content-type": "text/html;charset=UTF-8",
        },
      });
    },
  } satisfies ExportedHandler;
  ```

* Python

  ```py
  from workers import WorkerEntrypoint, Response


  class Default(WorkerEntrypoint):
      async def fetch(self, request):
          html = """<!DOCTYPE html>
          <body>
            <h1>Hello World</h1>
            <p>This markup was generated by a Cloudflare Worker.</p>
          </body>"""


          headers = {"content-type": "text/html;charset=UTF-8"}
          return Response(html, headers=headers)
  ```

* Rust

  ```rs
  use worker::*;


  #[event(fetch)]
  async fn fetch(_req: Request, _env: Env, _ctx: Context) -> Result<Response> {
      let html = r#"<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>
      "#;
      Response::from_html(html)
  }
  ```

* Hono

  ```ts
  import { Hono } from "hono";
  import { html } from "hono/html";


  const app = new Hono();


  app.get("*", (c) => {
    const doc = html`<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker with Hono.</p>
      </body>`;


    return c.html(doc);
  });


  export default app;
  ```
